# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from .sdpackage import *
from .sdresource import *
from .sbs.sdsbsmodelgraph import *
from .sdapiobject import *
from .sdresource import *
from .sdapiobject import *
from .apiexception import APIException

class SDAppInteropMgr(SDAPIObject):
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDAppInteropMgr
        """
        super(SDAppInteropMgr, self).__init__(APIContext, handle, *args, **kwargs)

    def isEnabled(self) -> bool:
        """

        """
        outValue = ctypes.c_bool()
        _res = self.mAPIContext.SDAppInteropMgr_isEnabled(self.mHandle, ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue.value

    def isSamplerInstalled(self) -> bool:
        """

        """
        outValue = ctypes.c_bool()
        _res = self.mAPIContext.SDAppInteropMgr_isSamplerInstalled(self.mHandle, ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue.value

    def isPainterInstalled(self) -> bool:
        """

        """
        outValue = ctypes.c_bool()
        _res = self.mAPIContext.SDAppInteropMgr_isPainterInstalled(self.mHandle, ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue.value

    def isBridgeInstalled(self) -> bool:
        """

        """
        outValue = ctypes.c_bool()
        _res = self.mAPIContext.SDAppInteropMgr_isBridgeInstalled(self.mHandle, ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue.value

    def isStagerInstalled(self) -> bool:
        """

        """
        outValue = ctypes.c_bool()
        _res = self.mAPIContext.SDAppInteropMgr_isStagerInstalled(self.mHandle, ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue.value

    def saveSBSBeforePublishingOrSending(self) -> bool:
        """

        """
        outValue = ctypes.c_bool()
        _res = self.mAPIContext.SDAppInteropMgr_saveSBSBeforePublishingOrSending(self.mHandle, ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue.value

    def publishSBSARWithProgressDialog(self, sbsFilePath : str, sbsarFilePath : str, sdCompressionMode : SDCompressionMode) -> None:
        """

        :param sdCompressionMode: The value that indicates if the the data compression mode (See SDCompressionMode enum)
        """
        _res = self.mAPIContext.SDAppInteropMgr_publishSBSARWithProgressDialog(self.mHandle, ctypes.create_string_buffer(sbsFilePath.encode('utf-8')), ctypes.create_string_buffer(sbsarFilePath.encode('utf-8')), sdCompressionMode.value)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def sendPackageToSampler(self, sdPackage : SDPackage) -> None:
        """

        """
        _res = self.mAPIContext.SDAppInteropMgr_sendPackageToSampler(self.mHandle, sdPackage.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def sendPackageToPainter(self, sdPackage : SDPackage) -> None:
        """

        """
        _res = self.mAPIContext.SDAppInteropMgr_sendPackageToPainter(self.mHandle, sdPackage.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def sendPackageToStager(self, sdPackage : SDPackage) -> None:
        """

        """
        _res = self.mAPIContext.SDAppInteropMgr_sendPackageToStager(self.mHandle, sdPackage.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def sendPackageToPlayer(self, sdPackage : SDPackage) -> None:
        """

        """
        _res = self.mAPIContext.SDAppInteropMgr_sendPackageToPlayer(self.mHandle, sdPackage.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def showPackageInBridge(self, sdPackage : SDPackage) -> None:
        """

        """
        _res = self.mAPIContext.SDAppInteropMgr_showPackageInBridge(self.mHandle, sdPackage.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def showResourceInBridge(self, sdResource : SDResource) -> None:
        """

        """
        _res = self.mAPIContext.SDAppInteropMgr_showResourceInBridge(self.mHandle, sdResource.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def resendPackage(self, sdPackage : SDPackage) -> None:
        """

        """
        _res = self.mAPIContext.SDAppInteropMgr_resendPackage(self.mHandle, sdPackage.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def hasPackageBeenSent(self, sdPackage : SDPackage) -> bool:
        """

        """
        outValue = ctypes.c_bool()
        _res = self.mAPIContext.SDAppInteropMgr_hasPackageBeenSent(self.mHandle, sdPackage.mHandle, ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue.value

    def updateSentToHistory(self) -> None:
        """

        """
        _res = self.mAPIContext.SDAppInteropMgr_updateSentToHistory(self.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def sendModelGraphToStager(self, sdGraph : SDSBSModelGraph) -> None:
        """

        """
        _res = self.mAPIContext.SDAppInteropMgr_sendModelGraphToStager(self.mHandle, sdGraph.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def getLastErrorMessage(self) -> str:
        """

        """
        outMessage = ctypes.c_char_p()
        _res = self.mAPIContext.SDAppInteropMgr_getLastErrorMessage(self.mHandle, ctypes.byref(outMessage))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outMessage.value.decode('utf-8') # type: ignore

